
int gridX=8; // columns > attention 8 columns => 9 grid lines
int gridY=8; // rows 

void setup()
{
   size(1000,600);
   noLoop();
}

void draw()
{
  background(255);
  
  noFill();
  drawGrid();
  stroke(0,0,0);
  // 24 lines from the center
  //stroke(255,0,0);
  for (int i=0;i<24;i++)
  {  
    PVector p=getGridPoint();
    line(width/2, height/2, p.x,p.y);
  }
  
  // 12 lines from each corner (to a grid point)
 // stroke(0,0,0);
  for (int i=0;i<12;i++)
  { 
    PVector p=getGridPoint();
    line(0, 0, p.x,p.y);
    
    p=getGridPoint();
    line(width, 0, p.x,p.y);
    
    p=getGridPoint();
    line(width, height, p.x,p.y);
    
    p=getGridPoint();
    line(0, height, p.x,p.y);
   }
}

// Get a random crosspoint in the grid
PVector getGridPoint()
{ //a grid of 8 has 9 cross points (0...8)
  int gx=int(random(0,gridX+1)); // upper limit is not included in the random range
  int gy=int(random(0,gridY+1)); // upper limit is not included in the random range
  PVector p=new PVector(gx*width/gridX, gy*height/gridY);
 
  return (p);
}

// Draw the grid lines
void drawGrid()
{stroke(200);
  for (int i=0; i<=gridX; i++)
     {line (i*width/gridX,0,i*width/gridX,height);
       
     }
 for (int j=0;j<=gridY;j++)
     {line(0,j*height/gridY,width,j*height/gridY);
     }     
}

void keyPressed() 
{
   redraw();
}
